<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ob_start();
session_start();

if (!isset($_SESSION['cod_id'])) {
    unset($_SESSION['cod_id']);
    header('location: ../');
    exit;
}

$cod_id = $_SESSION['cod_id'];

require_once __DIR__ . '/../../db/Conexao.php';
require_once __DIR__ . '/../../master/classes/functions.php';

function sendCurlRequest($url, $token, $data)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token,
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    return $response;
}

$idcliente = isset($_POST['vercli']) ? $_POST['vercli'] : '';

$formapagamento = $_POST['formapagamento'];
$parcelas = $_POST['parcelas'];
$dataparcela = DateTime::createFromFormat('d/m/Y', $_POST['dataparcela']);
$dataparcelax = $_POST['dataparcelax'];
$idpedido = $_POST['idpedido'];
$vparcela = $_POST['vparcela'];


// error_log("ID Cliente: " . $idcliente);
// error_log("Forma de Pagamento: " . $formapagamento);
// error_log("Parcelas: " . $parcelas);
// error_log("Data da Primeira Parcela: " . $dataparcela->format('d/m/Y'));
// error_log("Data da Primeira Parcela (Original): " . $dataparcelax);
// error_log("ID do Pedido: " . $idpedido);
// error_log("Valor da Parcela: " . $vparcela);
// error_log("". $dataparcelax);
// error_log("". $dataparcela->format(""));

$deleteOldEntries = $connect->prepare("DELETE FROM financeiro2 WHERE idc = ?");
$deleteOldEntries->execute([$idcliente]);

for ($i = 1; $i <= $parcelas; $i++) {
    $dataparcela_string = $dataparcela->format('d/m/Y');
    $insertFinanceiro2 = $connect->prepare("INSERT INTO financeiro2 (idc, chave, idm, datapagamento, parcela) VALUES (?, ?, ?, ?, ?)");
    $insertFinanceiro2->execute([$idcliente, $idpedido, $cod_id, $dataparcela_string, $vparcela]);


    $dataparcela->modify('+1 month');
}




$formapagamento = number_format($vparcela, 2, '.', '');
$dataparcela_string_financeiro1 = $dataparcela->format('Y-m-d');

$updateFinanceiro1 = $connect->prepare("UPDATE financeiro1 SET chave = ?, parcelas = ?, valorfinal = ?, primeiraparcela = ? WHERE idc = ? AND status = ?");
$updateFinanceiro1->execute([$idpedido, $parcelas, $formapagamento, $dataparcela_string_financeiro1, $idcliente, 1]);

$vencimento_primeira_parcela = DateTime::createFromFormat('d/m/Y', $_POST['dataparcela']);

for ($parcela = 1; $parcela <= $parcelas; $parcela++) {
    $dataParcela = clone $vencimento_primeira_parcela;
    $dataParcela->add(new DateInterval('P' . ($parcela - 1) . 'M'));
    if ($dataParcela->format('d') != $vencimento_primeira_parcela->format('d')) {
        $dataParcela->modify('last day of last month');
    }
    $qwerr = $dataParcela->format('d/m/Y');

    $getMaster = $connect->query("SELECT * FROM carteira WHERE Id = '" . $cod_id . "'");
    $masterInfo = $getMaster->fetch(PDO::FETCH_OBJ);

    $tokenmp = $masterInfo->tokenmp;

    $getClient = $connect->query("SELECT Id, nome, celular, email FROM clientes WHERE id = '" . $idcliente . "'");
    $clientInfo = $getClient->fetch(PDO::FETCH_OBJ);

    $nameParts = explode(" ", $clientInfo->nome);
    $firstName = $nameParts[0];
    $lastName = end($nameParts);
    $email = $clientInfo->email;

    $amount = $vparcela;
    $cobId = $idpedido;
    $paymentDate = $qwerr;

    $data = '{
        "transaction_amount": ' . $amount . ',
        "description": "PAGAMENTO DE MENSALIDADE ' . $firstName . '",
        "payment_method_id": "pix",
        "payer": {
            "email": "' . $email . '",
            "first_name": "' . $firstName . '",
            "last_name": "' . $lastName . '"
        }
    }';

    $response = sendCurlRequest('https://api.mercadopago.com/v1/payments', $tokenmp, $data);
    $response = json_decode($response, true);

    $transactionId = $response["id"];
    $createdDate = date("Y-m-d H:i:s");
    $status = $response["status"];
    $totalPaid = $response["transaction_details"]["total_paid_amount"];
    $codePix = $response["point_of_interaction"]["transaction_data"]["qr_code"];
    $qrcodeBase64 = $response["point_of_interaction"]["transaction_data"]["qr_code_base64"];

    if ($status == "pending") {
        $add = $connect->prepare("INSERT INTO mercadopago (idc, status, instancia, data, valor, idp, qrcode, linhad) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE status = VALUES(status), instancia = VALUES(instancia), data = VALUES(data), valor = VALUES(valor), qrcode = VALUES(qrcode), linhad = VALUES(linhad)");
        $add->execute([$idcliente, $status, $cobId, $createdDate, $totalPaid, $transactionId, $qrcodeBase64, $codePix]);
    }
}

header("location: ../contas_receber&sucesso=ok");
exit;
?>
