<?php
require_once "topo.php";
?>
	<div class="slim-mainpanel">
		<div class="container">
			<div align="right" class="mg-b-10"><a href="usuarios" class="btn btn-purple btn-sm"> VOLTAR</a></div>

			<div class="row">
				<div class="col-md-12">
					<div class="card card-info">
						<div class="card-body" align="justify">
							<label class="section-title">
								<i class="fa fa-check-square-o" aria-hidden="true"></i>
								CADASTRO DE USUÁRIOS
							</label>

							<hr>

							<form action="classes/funcionario_exe.php" method="post">
								<input type="hidden" name="cad_cli" value="ok">

								<div class="row">
									<div class="col-md-4">
										<div class="form-group">
											<label>Nome Completo</label>

											<input type="text" class="form-control" name="nome" maxlength="160" onkeydown="upperCaseF(this)" required>
										</div>
									</div>

									<div class="col-md-2">
										<div class="form-group">
											<label>Celular/WhatsApp</label>

											<div class="styled-select">
												<input type="text" class="form-control" name="celular" maxlength="11" onkeypress="return event.charCode >= 48 && event.charCode <= 57" required>
											</div>
										</div>
									</div>

									<div class="col-md-2">
										<div class="form-group">
											<label>LOGIN</label>

											<div class="styled-select">
												<input type="text" class="form-control" name="email" required>
											</div>
										</div>
									</div>

									<div class="col-md-2">
										<div class="form-group">
											<label>Senha</label>

											<div class="styled-select">
												<input type="password" class="form-control" name="senha" maxlength="11" required>
											</div>
										</div>
									</div>

									<div class="col-md-2">
										<div class="form-group">
											<label>Assinatura</label>

											<div class="styled-select">
												<input id="dateMask" type="text" class="form-control" name="assinatura" maxlength="19" required>
											</div>
										</div>
									</div>

									<input type="hidden" name="tipo" value="2">
								</div>

								<hr />

								<div class="row">
									<div class="col-md-12">
										<div align="center">
											<button type="submit" class="btn btn-primary" name="cart">Salvar <i class="fa fa-arrow-right"></i></button>
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<script src="../lib/jquery/js/jquery.js"></script>
	<script src="../lib/bootstrap/js/bootstrap.js"></script>
	<script src="../lib/jquery.cookie/js/jquery.cookie.js"></script>
	<script src="../lib/jquery.maskedinput/js/jquery.maskedinput.js"></script>
	<script src="../lib/select2/js/select2.full.min.js"></script>
	<script src="../js/moeda.js"></script>
	<script>
	$(function () {
		'use strict';

		$('#cel').mask('(99)99999-9999');

		$('#numb').mask('9999');

		$('#dateMask').mask('00/00/0000');
	});

	function upperCaseF(a) {
		setTimeout(function () {
			a.value = a.value.toUpperCase();
		}, 1);
	}

	$(document).ready(function () {
		function limpa_formulário_cep() {
			// Limpa valores do formulário de cep.
			$("#rua").val("");

			$("#bairro").val("");

			$("#cidade").val("");

			$("#uf").val("");

			$("#ibge").val("");
		}

		//Quando o campo cep perde o foco.
		$("#cep").blur(function () {
			//Nova variável "cep" somente com dígitos.
			var cep = $(this).val().replace(/\D/g, '');

			//Verifica se campo cep possui valor informado.
			if (cep != "") {
				//Expressão regular para validar o CEP.
				var validacep = /^[0-9]{8}$/;

				//Valida o formato do CEP.
				if (validacep.test(cep)) {
					//Preenche os campos com "..." enquanto consulta webservice.
					$("#rua").val("...");

					$("#bairro").val("...");

					$("#cidade").val("...");

					$("#uf").val("...");

					$("#ibge").val("...");

					//Consulta o webservice viacep.com.br/
					$.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {
						if (!("erro" in dados)) {
							//Atualiza os campos com os valores da consulta.
							$("#rua").val(dados.logradouro);

							$("#bairro").val(dados.bairro);

							$("#cidade").val(dados.localidade);

							$("#uf").val(dados.uf);

							$("#ibge").val(dados.ibge);
						} else {
							//CEP pesquisado não foi encontrado.
							limpa_formulário_cep();

							alert("CEP não encontrado.");
						}
					});
				} else {
					//cep é inválido.
					limpa_formulário_cep();

					alert("Formato de CEP inválido.");
				}
			} else {
				//cep sem valor, limpa formulário.
				limpa_formulário_cep();
			}
		});
	});
	</script>

	<script src="../js/slim.js"></script>
</body>
</html>
