<?php

require_once __DIR__ . '/db/Conexao.php';

if (isset($_POST["login"])) {
  $login = $_POST['login'];
  echo "Login: $login<br>"; // Debug: imprimir o login

  $password = $_POST['password'];
  echo "Senha (não criptografada): $password<br>"; // Debug: imprimir a senha não criptografada

  $password = sha1($password);
  echo "Senha (criptografada): $password<br>"; // Debug: imprimir a senha criptografada

  $user = $connect->prepare("SELECT * FROM carteira WHERE login = :login AND senha = :password AND status = 1");

  $user->execute(['login' => $login, 'password' => $password]);

  $count = $user->rowCount();
  echo "Número de usuários encontrados: $count<br>"; // Debug: imprimir o número de usuários encontrados

  $userData = $user->fetch(PDO::FETCH_OBJ);

  session_start(); // Inicia a sessão



}

$url_base = "https://$_SERVER[HTTP_HOST]";

$cod_id = $_SESSION['cod_id'];


$adm_id = "1";

$editarcat = $connect->prepare("SELECT * FROM carteira WHERE Id = :adm_id");
$editarcat->execute([':adm_id' => $adm_id]);
$dadoscat = $editarcat->fetch(PDO::FETCH_OBJ);


$backgroundStyle = "";
if ($cod_id == 1 && $dadoscat->background) {
  $backgroundStyle = "background-image: url('" . $dadoscat->background . "');";
}


createTablesAndAddColumnIfNotExist($connect);


?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="utf-8">

  <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">

  <meta name="description"
    content="<?php print $_nomesistema; ?> é o melhor sistema para cobranças e notificações via WhatsApp">

  <meta name="keywords" content="financeiro, cobranças, whatsapp">

  <meta property="og:url" content="<?php print $_urlmaster; ?>">

  <meta property="og:title" content="<?php print $_nomesistema; ?>">

  <meta property="og:description" content="Cobranças automáticas para whatsapp.">

  <meta property="og:type" content="website">

  <meta property="og:image" content="<?php print $_urlmaster; ?>/img/favicon.png">

  <meta property="og:image:width" content="520">

  <meta property="og:image:type" content="image/png">

  <meta property="og:site_name" content="<?php print $_nomesistema; ?>">

  <meta property="og:locale" content="pt-BR">

  <title>Whatsapp Cobranças: Integre sua empresa | <?php print $_nomesistema; ?></title>

  <link rel="icon" href="<?php print $_urlmaster; ?>/img/favicon.png" sizes="32x32" type="image/png">

  <link id="style" href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />

  <link href="lib/font-awesome/css/font-awesome.css" rel="stylesheet">

  <link href="lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link rel="stylesheet" href="/styles/dark-mode.css">

  <link rel="stylesheet" href="css/slim.css">

  <script src="https://www.google.com/recaptcha/api.js"></script>

  <style>
    body {
      color: #000;
      overflow-x: hidden;
      height: 100%;
      background: linear-gradient(45deg, #D96D00 50%, #EEEEEE 50%);
      background-repeat: no-repeat
    }

    .signin-box {
      background-color: white;
    }

    .card0 {
      box-shadow: 0px 4px 8px 0px #757575;
      border-radius: 10px;
    }

    .card1 {
      justify-content: center;
      align-items: center;
    }

    .logo {
      border-radius: 50%;
      width: 30px;
      height: 30px;
      margin-top: 20px;
      margin-left: 25px
    }

    .image {
      width: 300px;
      display: block;
      margin-left: auto;
      margin-right: auto
    }

    .card2 {
      border-bottom-right-radius: 10px;
      border-top-right-radius: 10px
    }

    .login {
      cursor: pointer
    }

    .line {
      height: 1px;
      width: 45%;
      background-color: #E0E0E0;
      margin-top: 10px
    }

    .or {
      width: 10%
    }

    .text-sm {
      font-size: 14px !important
    }

    input,
    textarea {
      padding: 10px 12px 10px 12px;
      border: 1px solid lightgrey;
      border-radius: 4px;
      margin-bottom: 25px;
      margin-top: 2px;
      width: 100%;
      box-sizing: border-box;
      color: #2C3E50;
      font-size: 14px;
      letter-spacing: 1px;
      background-color: #ECEFF1
    }

    input:focus,
    textarea:focus {
      -moz-box-shadow: none !important;
      -webkit-box-shadow: none !important;
      box-shadow: none !important;
      border: 1px solid #304FFE;
      outline-width: 0
    }

    button:focus {
      -moz-box-shadow: none !important;
      -webkit-box-shadow: none !important;
      box-shadow: none !important;
      outline-width: 0
    }

    .btn-blue {
      background-color: #304FFE;
      width: 100%;
      color: #fff;
      border-radius: 6px
    }

    .btn-blue:hover {
      background-color: #0D47A1;
      width: 100%;
      color: #fff;
      cursor: pointer
    }

    .btn-green {
      background-color: #00B200;
      width: 100%;
      color: #fff;
      border-radius: 6px
    }

    .btn-green:hover {
      background-color: #008C00;
      width: 100%;
      color: #fff;
      cursor: pointer
    }

    @media screen and (max-width: 991px) {
      .card1 {
        border-bottom-left-radius: 0px;
        border-top-right-radius: 10px;
        justify-content: center;
        align-items: center;
      }

      .card2 {
        border-bottom-left-radius: 10px;
        border-top-right-radius: 0px
      }
    }
  </style>
</head>

<body class="ltr error-page1 bg-primary" id="pagina" style="<?php echo $backgroundStyle; ?>">
  <div class="signin-wrapper">
    <div class="signin-box" align="center">
      <h3>Painel Financeiro</h3>

      <hr/>

      <form id="loginForm">
        <div class="form-group">
          <input type="text" class="form-control" id="login" name="login" placeholder="Login" required>
        </div>

        <div class="form-group">
          <input type="password" class="form-control" id="password" name="password" placeholder="Senha" maxlength="16"
            required>
        </div>

        <div class="form-group mg-b-1">
          <center>
            <div class="g-recaptcha" data-callback="recaptchaCallback" data-sitekey="<?php print $_captcha; ?>"></div>
          </center>
        </div>

        <?php if (isset($_GET["erro"])) { ?>
          <div class="form-group" style="color:#FF0000">
            <i class="fa fa-certificate"></i> E-mail ou Senha incorreto.
          </div>
        <?php } ?>

        <button type="submit" id="submit" name="submit" class="btn btn-dark btn-block"
          disabled="disabled">Entrar</button>
      </form>

      <?php if ($_ativacom == "1") { ?>
        <a href="./criar_conta" class="btn btn-info btn-block mg-t-10">Nova Conta</a>

        <a href="./recuperar_senha" class="btn btn-danger btn-block mg-t-10">Recuperar Senha</a>
      <?php } ?>
    </div>
  </div>
  <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.js"></script>
  <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.css">
  <script src="https://www.google.com/recaptcha/api.js" async defer></script>
  <script>function recaptchaCallback() { jQuery("#submit").prop("disabled", false); }</script>


  <script>
    $(document).ready(function () {
      $("#loginForm").submit(function (e) {
        e.preventDefault();

        var login = $("#login").val();
        var password = $("#password").val();

        $.ajax({
          url: 'login.php',
          type: 'post',
          data: {
            login: login,
            password: password,
            cod_id: '<?php echo $_SESSION['cod_id']; ?>'
          },
          success: function (response) {
            try {
              var data = JSON.parse(response);
              if (data.status == 'success') {
                $.toast({
                  heading: 'Sucesso',
                  text: data.message,
                  showHideTransition: 'slide',
                  icon: 'success',
                  position: 'top-right'
                });
                window.location.href = data.redirect;
              } else {
                $.toast({
                  heading: 'Erro',
                  text: data.message,
                  showHideTransition: 'slide',
                  icon: 'error',
                  position: 'top-right'
                });
              }
            } catch (e) {
            }
          },
          error: function (jqXHR, textStatus, errorThrown) {
            $.toast({
              heading: 'Erro',
              text: 'Ocorreu um erro ao tentar fazer login. Tente novamente mais tarde.',
              showHideTransition: 'slide',
              icon: 'error',
              position: 'top-right'
            });
          }
        });
      });
    });
  </script>
</body>

</html>